﻿//=============================================================================
// Sky.fx Frank Luna (C) 2011 Wszelkie prawa zastrzeżone.
//
// Efekt cieniujący kopułę nieba.
//=============================================================================

cbuffer cbPerFrame
{
	float4x4 gWorldViewProj;
};
 
// Danych nienumerycznych nie można zapisywać w obiekcie cbuffer.
TextureCube gCubeMap;
 
SamplerState samTriLinearSam
{
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = Wrap;
	AddressV = Wrap;
};

struct VertexIn
{
	float3 PosL : POSITION;
};

struct VertexOut
{
	float4 PosH : SV_POSITION;
    float3 PosL : POSITION;
};
 
VertexOut VS(VertexIn vin)
{
	VertexOut vout;
	
	// Ustaw z = w, aby z/w = 1 (czyli kopuła nieba znajduje się zawsze w dalszej płaszczyźnie).
	vout.PosH = mul(float4(vin.PosL, 1.0f), gWorldViewProj).xyww;
	
	// Użyj lokalnej pozycji wierzchołka jako wektora wyszukiwania w teksturze sześciennej.
	vout.PosL = vin.PosL;
	
	return vout;
}

float4 PS(VertexOut pin) : SV_Target
{
	return gCubeMap.Sample(samTriLinearSam, pin.PosL);
}

RasterizerState NoCull
{
    CullMode = None;
};

DepthStencilState LessEqualDSS
{
	// W funkcji głębokości należy użyć nierówności słabej (LESS_EQUAL) zamiast ostrej (LESS)  
	// W przeciwnym razie znormalizowane wartości głębokości przy z = 1 (NDC) 
	// nie przejdą testu głębokości, jeśli bufor zostanie wypełniony jedynkami.
    DepthFunc = LESS_EQUAL;
};

technique11 SkyTech
{
    pass P0
    {
        SetVertexShader( CompileShader( vs_5_0, VS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_5_0, PS() ) );
        
        SetRasterizerState(NoCull);
        SetDepthStencilState(LessEqualDSS, 0);
    }
}
